Attribute VB_Name = "modTimers"
Option Explicit

Public Declare Function SetTimer Lib "user32" (ByVal hwnd As Long, ByVal nIDEvent As Long, ByVal uElapse As Long, ByVal lpTimerFunc As Long) As Long
Public Declare Function KillTimer Lib "user32" (ByVal hwnd As Long, ByVal nIDEvent As Long) As Long

Public Sub timerConnectAllBots()
    Static tmrBotIndex  As Integer
    If (tmrBotIndex < UBound(Bots)) Then
        'Bot must be disconnected
        If (Bots(tmrBotIndex).Connected = False) Then
            Call closeBot(tmrBotIndex)
            Call connectBot(tmrBotIndex)
        End If
        tmrBotIndex = tmrBotIndex + 1
        KillTimer frmMain.hwnd, 1
        SetTimer frmMain.hwnd, 1, G_Settings.Connect_Delay, AddressOf timerConnectAllBots
    Else
        tmrBotIndex = 0
        KillTimer frmMain.hwnd, 1
    End If
End Sub

Public Sub timerQueueBotMessages()
    Dim strMessage  As String
    Dim i           As Integer
    
    'Loop through Queue classes for each bot.
    For i = 0 To UBound(ProfileHandler) - 1
        'Check queue to make sure it even has contents, no sense in using extra overhead then we need to.
        If (ProfileHandler(i).Queue.QueueCount > 0) Then
            If (G_Options.Queue_Usage) Then
                strMessage = ProfileHandler(i).Queue.GetQueue() 'Get the message set botindexes queue class based on priority and index level.
            Else
                strMessage = ProfileHandler(i).Queue.PeekQueue(0)
                Call ProfileHandler(i).Queue.DeleteQueue(0)
            End If
            If (strMessage <> vbNullString) Then 'Check message
                Call ConnectionHandler.BNCSHandler.setClassVars(i, frmMain.sckBNET(i))
                Call ConnectionHandler.BNCSHandler.sendSID_CHATCOMMAND(strMessage) 'Send out message
            End If
        End If
    Next i
    
    'Kill timer and reset it to constantly keep checking the queue of each bot.
    KillTimer frmMain.hwnd, 2
    SetTimer frmMain.hwnd, 2, 100, AddressOf timerQueueBotMessages
End Sub

Public Sub timerAutoReconnect()
    Static tmrBotIndex  As Integer
    Dim i As Integer
    
    If (tmrBotIndex < UBound(Bots)) Then 'Loops through and connects all the bots before reaching the total bot loop where it reconnect delays.
        If (Bots(tmrBotIndex).ConnectionKilled And Bots(tmrBotIndex).Connected = False) Then
            Call connectBot(tmrBotIndex)
            tmrBotIndex = tmrBotIndex + 1
            KillTimer frmMain.hwnd, 3
            SetTimer frmMain.hwnd, 3, G_Settings.Connect_Delay, AddressOf timerAutoReconnect
        Else
            'Didn't connect bot anyway, 1ms delay time.
            tmrBotIndex = tmrBotIndex + 1
            KillTimer frmMain.hwnd, 3
            SetTimer frmMain.hwnd, 3, 1, AddressOf timerAutoReconnect
        End If
    Else 'tmrBotIndex is 0 meaning it looped through all bots and attempted a connect.
        tmrBotIndex = 0
        KillTimer frmMain.hwnd, 3
        
        'Loop through bots, if a bot STILL is connectionkilled and not connected then set a timer to loop through all the bots but use reconnect delay.
        For i = 0 To UBound(Bots) - 1
            If (Bots(i).Connected = False And Bots(i).ConnectionKilled) Then
                SetTimer frmMain.hwnd, 3, G_Settings.Reconnect_Delay, AddressOf timerAutoReconnect
                Exit For
            End If
        Next i
    End If
End Sub

Public Sub timerAutoAway()
    Dim i               As Integer
    Dim TimerDelay      As Long
    
    TimerDelay = 8000       '(15# * 60 * 60 * 1000)  '15 minutes
    
    If (G_Options.Auto_Away) Then
        For i = 0 To UBound(Bots) - 1
            '30 minutes
            If (Bots(i).Connected) Then
                If (((GetTickCount() - ProfileHandler(i).UPTIME_IDLE) / 1000 / 60 / 60) >= G_Settings.AutoAwayTime) Then
                    AddQueue i, "/away [Away for: " & FormatGTC(GetTickCount() - ProfileHandler(i).UPTIME_IDLE) & "] -- " & Bot_Name & " by " & Bot_Author
                End If
            End If
        Next i
    End If
    
    KillTimer frmMain.hwnd, 4
    SetTimer frmMain.hwnd, 4, TimerDelay, AddressOf timerAutoAway
End Sub

Public Sub timerNewsRetrieval()
    If (frmMain.sckInternet.State = sckClosed) Then
        frmMain.sckInternet.Connect Internet_Host, 80
    End If
    
    '3 sec delay
    KillTimer frmMain.hwnd, 5
    SetTimer frmMain.hwnd, 5, 3000, AddressOf timerNewsRetrieval
End Sub
